/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.toolkit.expr;

import filenet.vw.api.VWException;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class VWIDMToken {
    private Object value = null;
    private String stringValue = null;
    private Object[] choices = null;
    private String propertyName = null;
    private int type = -1;
    private boolean isMultiValue = false;
    private boolean bBadIdentToken = false;
    private boolean isPropertyToken = false;
    private boolean debug = false;
    private static String TIME_MASK = "MM/dd/yyyy HH:mm:ss zzz";
    public static final int TypeInvalid = -1;
    public static final int TypeInt = 1;
    public static final int TypeString = 2;
    public static final int TypeBoolean = 4;
    public static final int TypeDouble = 8;
    public static final int TypeDate = 16;
    public static final int TypeUndefined = 32;

    protected static void setDateTimeMask(String dateTimeMask) {
        if (dateTimeMask != null) {
            TIME_MASK = dateTimeMask;
        }
    }

    protected VWIDMToken(String propName, IVWIDMPropertyDescription[] thePropDescriptions, IVWIDMItem theDocument, boolean evaluate, boolean doDebug) {
        this.debug = doDebug;
        this.isPropertyToken = true;
        this.propertyName = propName;
        if (evaluate) {
            this.init(this.propertyName, theDocument, thePropDescriptions);
        } else {
            this.init(this.propertyName, thePropDescriptions);
        }
    }

    protected VWIDMToken(String strValue, int theType, boolean doDebug) {
        this.debug = doDebug;
        this.stringValue = strValue;
        this.init(this.stringValue, theType);
    }

    protected VWIDMToken(Object theValue, int theType, boolean isAMultiValue, boolean doDebug) {
        this.value = theValue;
        this.type = theType;
        this.isMultiValue = isAMultiValue;
        this.debug = doDebug;
    }

    protected int getType() {
        return this.type;
    }

    protected void setType(int theType) {
        this.type = theType;
    }

    protected Object getValue() {
        return this.value;
    }

    protected void setValue(Object theValue) {
        this.value = theValue;
    }

    protected String getStringValue() {
        return this.stringValue;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected boolean isBadIdentToken() {
        return this.bBadIdentToken;
    }

    protected boolean isMultiValue() {
        return this.isMultiValue;
    }

    protected boolean isPropertyToken() {
        return this.isPropertyToken;
    }

    protected boolean hasChoices() {
        return this.choices != null;
    }

    protected boolean isValidChoice(VWIDMToken tk) {
        Object tmp = null;
        boolean validChoice = false;
        int valType = tk.getType();
        Object val = tk.getValue();
        int i = 0;
        if (this.hasChoices() && val != null) {
            tmp = val;
            if (valType == 1 && this.type == 8) {
                tmp = new Double(((Integer)val).doubleValue());
            } else if (valType == 2 && this.type == 16) {
                tmp = VWIDMToken.getDateValue((String)val);
            }
            if (tmp != null) {
                if (this.getType() == 16) {
                    for (i = 0; i < this.choices.length; ++i) {
                        if (!((GregorianCalendar)tmp).getTime().equals(((GregorianCalendar)this.choices[i]).getTime())) continue;
                        validChoice = true;
                        break;
                    }
                } else {
                    for (i = 0; i < this.choices.length; ++i) {
                        if (!tmp.equals(this.choices[i])) continue;
                        validChoice = true;
                        break;
                    }
                }
            }
        } else {
            validChoice = true;
        }
        return validChoice;
    }

    protected static GregorianCalendar getDateValue(String dateString) {
        Date dateVal = null;
        GregorianCalendar gc = null;
        SimpleDateFormat df = new SimpleDateFormat();
        try {
            df.applyPattern(TIME_MASK);
            dateVal = df.parse(dateString);
            gc = new GregorianCalendar();
            gc.setTime(dateVal);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return gc;
    }

    private void init(String propName, IVWIDMPropertyDescription[] propDescriptions) {
        IVWIDMPropertyDescription propDesc = null;
        try {
            propDesc = this.findPropDescription(propName, propDescriptions);
            if (propDesc != null) {
                if (propDesc.hasChoices()) {
                    this.choices = propDesc.getChoices();
                }
                this.type = this.convertType(propDesc.getTypeID());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (propDesc == null && propDescriptions != null && propDescriptions.length > 0) {
            this.PrintDebug("Could not get the property description.");
            this.PrintDebug("The property name was: " + propName);
            this.bBadIdentToken = true;
        }
    }

    private void init(String propName, IVWIDMItem theDocument, IVWIDMPropertyDescription[] propDescriptions) {
        IVWIDMPropertyDescription prop = null;
        Object tmp = null;
        Object[] multiValue = null;
        try {
            if (theDocument != null) {
                this.value = theDocument.getProp(propName);
                if (this.value != null && this.value.getClass().isArray()) {
                    this.isMultiValue = true;
                    multiValue = (Object[])this.value;
                    if (multiValue.length <= 0) {
                        this.value = null;
                    }
                }
                if (this.value != null) {
                    tmp = this.isMultiValue && multiValue.length > 0 ? multiValue[0] : this.value;
                    if (tmp instanceof String) {
                        this.type = 2;
                    } else if (tmp instanceof Integer) {
                        this.type = 1;
                    } else if (tmp instanceof GregorianCalendar) {
                        this.type = 16;
                    } else if (tmp instanceof Double) {
                        this.type = 8;
                    } else if (tmp instanceof Boolean) {
                        this.type = 4;
                    }
                } else {
                    prop = this.findPropDescription(propName, propDescriptions);
                    this.type = prop != null ? this.convertType(prop.getTypeID()) : -1;
                }
            }
        }
        catch (VWException e) {
            this.value = null;
            this.bBadIdentToken = true;
            this.PrintDebug("Could not get the property value from the document.");
            this.PrintDebug("The property name was: " + propName);
        }
    }

    private void init(String strValue, int theType) {
        try {
            switch (theType) {
                case 1: {
                    this.value = new Integer(strValue);
                    this.type = 1;
                    break;
                }
                case 8: {
                    this.value = new Double(strValue);
                    this.type = 8;
                    break;
                }
                case 2: {
                    this.value = strValue;
                    this.type = 2;
                    break;
                }
                case 4: {
                    this.value = new Boolean(strValue);
                    this.type = 4;
                    break;
                }
                default: {
                    this.value = null;
                    this.type = -1;
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            this.value = null;
        }
        if (this.value == null) {
            this.PrintDebug("Error getting the token value.");
        }
    }

    private IVWIDMPropertyDescription findPropDescription(String name, IVWIDMPropertyDescription[] propDescriptions) {
        IVWIDMPropertyDescription theProp;
        block3: {
            theProp = null;
            try {
                if (propDescriptions == null || propDescriptions.length <= 0) break block3;
                for (int i = 0; i < propDescriptions.length; ++i) {
                    if (!propDescriptions[i].getName().equals(name)) continue;
                    theProp = propDescriptions[i];
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return theProp;
    }

    private int convertType(int theType) {
        int newType = -1;
        switch (theType) {
            case 11: {
                newType = 4;
                break;
            }
            case 7: {
                newType = 16;
                break;
            }
            case 3: {
                newType = 1;
                break;
            }
            case 5: {
                newType = 8;
                break;
            }
            case 8: {
                newType = 2;
                break;
            }
            default: {
                newType = -1;
            }
        }
        return newType;
    }

    private void PrintDebug(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }
}

